% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreBrowserPlot.R
\name{creGRToSignal}
\alias{creGRToSignal}
\title{Convert CreGR to Pseudo-Continuous Signal for Plotting}
\usage{
creGRToSignal(
  CreGR,
  plotRegionGR,
  useLogFC = TRUE,
  pValColName = "pVal",
  logFcColName = "logFC",
  creSignalBinRes = 100
)
}
\arguments{
\item{CreGR}{A \link[GenomicRanges]{GRanges} object representing CRE data.}

\item{plotRegionGR}{A \link[GenomicRanges]{GRanges} object specifying the
region of interest for plotting.}

\item{useLogFC}{Logical, indicating whether to consider log-fold change
values (Default: \code{TRUE}).}

\item{pValColName}{Character specifying the column name in CreGR containing
p-values (Default: \code{pVal}).}

\item{logFcColName}{Character specifying the column name in CreGR
containing log-fold change values (Default: \code{logFC}).}

\item{creSignalBinRes}{Numeric value specifying the bin resolution in base
pairs for the pseudo-continuous signal (Default: \code{100}).}
}
\value{
A \link[GenomicRanges]{GRanges} object with signal values in
metadata column \code{score}, suitable for plotting in
\link[plotgardener]{plotSignal}.
}
\description{
This function converts a GenomicRanges object containing CRE data
to a pseudo-continuous signal track suitable for plotting in plotgardener.
The signal is derived from p-values and, optionally, log-fold change values
associated with CREs.
}
\details{
Not exported. This function takes a \link[GenomicRanges]{GRanges} object
(\code{CreGR}) representing CRE data, extracts p-values, and,
if specified, log-fold change values. It then converts these values into a
signed -log p-value in the \code{signal} metadata column.
}
\examples{
\dontrun{
#Load example data.
data(DexNR3C1)

myCreGR <- DexNR3C1$CreGR
myPlotRegionGR <- GRanges(seqnames="chr4",
                          ranges=IRanges(start=3.6e6,end=3.8e6))

# Convert CRE data to a pseudo-continuous signal
creSignalGR <- creGRToSignal(CreGR=myCreGR, plotRegionGR=myPlotRegionGR)
}

}
\author{
Brian S. Roberts
}
\keyword{internal}
