% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreConversions.R
\name{convertdegCreResListToGInteraction}
\alias{convertdegCreResListToGInteraction}
\title{Convert DegCre Results List to GInteractions Object}
\usage{
convertdegCreResListToGInteraction(degCreResList, assocAlpha = 0.05)
}
\arguments{
\item{degCreResList}{List of DegCre results.}

\item{assocAlpha}{The significance threshold for associations to be included
in the output (Default: \code{0.05}).}
}
\value{
A \link[InteractionSet]{GInteractions} object containing the
associations that pass the specified significance threshold.

The \link[InteractionSet]{GInteractions} object has same metadata columns as
the \link[S4Vectors]{Hits} returned from \link{runDegCre} with additional
columns.
These additional columns are every metadata column in the input \code{DegGR}
or \code{CreGR} proceeded by either \code{Deg_} or \code{Cre_} in the
colname.
}
\description{
Given a DegCre results list, this function converts it into a GInteractions
object.
}
\details{
This function takes a DegCre results list as input and extracts the
significant associations based on the  \code{assocProbFDR} compared to the
specified significance threshold \code{assocAlpha}. It then creates a
\link[InteractionSet]{GInteractions} object  metadata columns from the input
list.

If no associations pass the significance threshold, the function returns
NA' and prints a message.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load test data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

#Create GInteractions object.
gInteractions <-
 convertdegCreResListToGInteraction(degCreResList=degCreResListDexNR3C1,
                                    assocAlpha = 0.01)

}
\author{
Brian S. Roberts
}
