% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/DeeDeeExperiment.R
\docType{class}
\name{DeeDeeExperiment-class}
\alias{DeeDeeExperiment-class}
\alias{.DeeDeeExperiment}
\alias{DeeDeeExperiment}
\title{The DeeDeeExperiment class}
\usage{
DeeDeeExperiment(
  sce = SingleCellExperiment(),
  de_results = NULL,
  enrich_results = NULL
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object, that will be used as a scaffold to
store the DE related information.}

\item{de_results}{A named list of DE results, in any of the formats supported
by the package (currently: results from \code{DESeq2}, \code{edgeR}, \code{limma}, \code{muscat}).}

\item{enrich_results}{A named list of functional enrichment results. Each
element can be either a data.frame (currently supports results from \code{topGO},
\code{enrichR}, \code{gProfiler}, \code{fgsea}, \code{gsea}, \code{DAVID}, and output of \code{GeneTonic}
shakers), or an \code{enrichResult}/\code{gseaResult} objects (currently supports
\code{clusterProfiler})}
}
\value{
A \code{DeeDeeExperiment} object.
}
\description{
The \code{DeeDeeExperiment} class is integrate and manage omics analysis
results. It inherits from the \code{SingleCellExperiment} class, and additionally
stores DE-related/functional enrichment information via dedicated slots and
\code{rowData}.
}
\details{
The \code{sce} parameter can be optionally left unspecified. If this is the case,
the resulting \code{DeeDeeExperiment} object will contain as features the ones
specified by the provided components of the object supplied via the
\code{de_results} parameter.

The conversion of the components of the \code{de_results} list will be handled via
conversion functions to uniform the names and set of information which will
be stored in the returned \code{DeeDeeExperiment} object.
The names of the list will be used to define the \code{contrasts} for the
different DE analyses included, which will determine the way to access the
information stored in the \code{dea} slot of the \code{DeeDeeExperiment} object.

The content of the \code{enrich_results} provided by the user will be validated to
ensure that it is properly formatted and correctly named. The FE tool can be
automatically detected, and based on that, the appropriate shaking method is
used to return a standardized format of the FEA results.
The names of the list will be used to attempt to associate each enrichment
result with a corresponding DE contrast stored in the \code{DeeDeeExperiment}
object, but it also can be defined by the user.

Since a \code{DeeDeeExperiment} is also a \code{SummarizedExperiment} object, it can be
seamlessly provided downstream for visualization and in-depth exploration to
packages such as \code{iSEE} or similar.
}
\section{Slots}{

\describe{
\item{\code{dea}}{This slot is designed to hold the DE-related information. This is
internally being created upon importing from the list of DE results objects,
provided when instantiating the \link{DeeDeeExperiment}.}

\item{\code{fea}}{This slot is designed to hold Functional Enrichment related
information.}
}}

\examples{
data("de_named_list", package = "DeeDeeExperiment")

dde_onlyde <- DeeDeeExperiment(
  de_results = de_named_list
)

# or, with a SE object as support - even without assay data available
library("SummarizedExperiment")

rd_macrophage <- DataFrame(
  gene_id = rownames(de_named_list$ifng_vs_naive)
)
rownames(rd_macrophage) <- rownames(de_named_list$ifng_vs_naive)
se_macrophage_noassays <- SummarizedExperiment(
  assays = SimpleList(),
  rowData = rd_macrophage
)

dde <- DeeDeeExperiment(
  se_macrophage_noassays,
  de_results = de_named_list
)
}
\author{
Najla Abassi, Lea Schwarz, and Federico Marini
}
