% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{est_prop}
\alias{est_prop}
\title{Bisque Estimated Cell Type Proportions for DLPFC bulk RNA-seq data}
\format{
A \code{data.frame} object.
}
\source{
\url{https://github.com/LieberInstitute/DeconvoBuddies/blob/master/inst/extdata/data-raw/est_prop.R}
}
\usage{
data("est_prop")
}
\description{
Cell type proportions estimated by Bisque for DLPFC bulk RNA-seq data set,
utilizing DLPFC snRNA-seq data as the reference data.
}
\details{
16.79 kB

These are the columns of the \code{data.frame} object:
\itemize{
\item Astro: estimated proportions of Astrocyte cells
\item EndoMural: estimated proportions of Endothelia + Mural cells
\item Micro: estimated proportions of Microglia cells
\item Oligo: estimated proportions of Oligodendrocyte Cells
\item OPC: estimated proportions of Oligodendrocyte Precursor Cells
\item Excit: estimated proportions for Excitatory Neurons
\item Inhib: estimated proportions for Inhibitory Neurons
}
}
\examples{
## R Note that the `rowSums(est_prop)` is equal to 1,
## with a small error tolerance.
data("est_prop")
summary(rowSums(est_prop) - 1)

## You can check this yourself with:
all(round(rowSums(est_prop), 3) == 1)

# To view source
system.file("extdata", "data-raw", "est_prop.R", package = "DeconvoBuddies")
}
\keyword{datasets}
