% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_peak.R
\name{geom_peak}
\alias{geom_peak}
\title{Plotting peaks}
\usage{
geom_peak(
  peaks.df = NULL,
  peak.label = FALSE,
  peak.color = "black",
  peak.size = 5,
  plot.space = 0.1,
  plot.height = 0.05
)
}
\arguments{
\item{peaks.df}{A data.frame of peaks as outputted from `identifyPeaks()`.}

\item{peak.label}{Specify whether peak_id labels should be added to the plot. Default is FALSE.}

\item{peak.color}{Specify colour of peak. Default is black.}

\item{peak.size}{Specify size of rectangle. Default is 5.}

\item{plot.space}{Specify gap to next plot. Recommend leaving to the default: 0.1.}

\item{plot.height}{Specify overall height of plot. Recommend leaving to the default: 0.05.}
}
\value{
A `ggplot_add` object.
}
\description{
`geom_peak` is a ggplot2 layer that visualises the positions of peaks across a given region.
* cannot be plotted by itself, must be added to an existing ggplot object - see examples.
}
\examples{
set.seed(123)
counts.df <- random_counts()
dm_results <- random_edgeR_results()
peaks <- identifyPeaks(dm_results)
plotCounts(counts.df,
    seqnames = "chr2L",
    start_region = 1,
    end_region = 40000,
    log2_scale = FALSE
) +
    geom_peak(peaks)

plotCounts(counts.df,
    seqnames = "chr2L",
    start_region = 1,
    end_region = 40000,
    log2_scale = FALSE
) +
    geom_peak(peaks, peak.label = TRUE)
# The plots can be layered -------------------------------------------------
}
\references{
ggcoverage - Visualise and annotate omics coverage with ggplot2. https://github.com/showteeth/ggcoverage/tree/main
}
\seealso{
[plotCounts()] [geom_dm()] [geom_genes.tx()] [geom_gatc()] [plotWrap()] [ggplot2::ggplot_add()]
}
