% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{DaMiR.makeSE}
\alias{DaMiR.makeSE}
\title{Import RNA-Seq count data and variables}
\usage{
DaMiR.makeSE(x, y)
}
\arguments{
\item{x}{A tab-delimited file which contains
RNA-Seq count data. Each row is a feature (i.e. gene, transcript,
exon etc.)
and each column is a sample}

\item{y}{A tab-delimited file which contains experiment information.
Each row is a sample and each column is a variable. This file must
contain
at least one column which represent 'class' information for data
 adjustment
and classification; the class column must be labeled as 'class'}
}
\value{
A \code{SummarizedExperiment} object containing raw counts,
class and (optionally) variables of interest.
}
\description{
This is an helper function that allows the user to
simultaneously
 import counts, class (mandatory) and
 variables (optional) data, and creates a \code{SummarizedExperiment}
 object.
}
\details{
Before creating a \code{SummarizedExperiment} object, the
function performs some checks on input data to ensure that only a
matrix
of raw counts is accordingly loaded. Other checks allows the
identification of missing data (NA) in the data frame of the variables
 of
interest.
}
\examples{
rawdata.path <- system.file(package = "DaMiRseq","extdata")
# import tab-delimited files:
# sample data are a small subset of Genotype-Tissue Expression (GTEx)
# RNA-Seq database (dbGap Study Accession: phs000424.v6.p1):
count_data <- read.delim(file.path(rawdata.path, "counts_import.txt"))
variables_data <- read.delim(file.path(rawdata.path, "annotation_import.txt"))
# create a SummarizedExperiment object:
SE <- DaMiR.makeSE(count_data, variables_data)
print(SE)

}
\references{
Morgan M, Obenchain V, Hester J and Pag\`es H (2016).
SummarizedExperiment: SummarizedExperiment container.
 R package version 1.4.0.
}
\seealso{
\code{\link{SummarizedExperiment}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
