% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classif_2_Classes_ModelSelection.R
\name{DaMiR.ModelSelect}
\alias{DaMiR.ModelSelect}
\title{Select the best classification model}
\usage{
DaMiR.ModelSelect(
  df,
  type.sel = c("mode", "median", "greater"),
  th.sel = 0.85,
  npred.sel = c("min", "rnd"),
  metric.idx = 1,
  npred.idx = 2
)
}
\arguments{
\item{df}{A data frame of performance metrics. At least two columns
representing a specific classification metrics (e.g., Accuracy) and
the number of predictors must be provided. Additionally,
other classification metrics (e.g., MCC, Sensitivity,
Specificity,PPV, NPV, AUC, ...) can be appended (from the third
column onwards) and used for the evaluation, by correctly setting
the 'metric.idx' parameter.}

\item{type.sel}{The method to select the best models. Only
"mode","median" and "greater" values are allowed.
For a specific classification metrics, "mode" selects all models
whose score is the mode of all scores; "median" selects all
models whose score is the median of all scores; and, "greater"
selects all models whose score is greater than the value
specified in "th.sel". Default: "mode".}

\item{th.sel}{Threshold for the evaluation of the performance
when "type.sel" is equal to "greater". Default: 0.85}

\item{npred.sel}{The method to select the best model. Only
"min" and "rnd" values are allowed. Taking into account the subset
of models found by 'type.sel', this parameter selects one single
model with the minimum number of predictors ("min") or randomly
("rnd"). Default: "min".}

\item{metric.idx}{The index of the 'df' column (i.e., classification
metrics) to be considered for the models evaluation. Default: 1.}

\item{npred.idx}{The index of the 'df' column representing the
number of predictors. Default: 2.}
}
\value{
The index of df (row), representing the model selected and a
bubble chart
}
\description{
This function selects the bestmodels learned by the
\link{DaMiR.EnsL_Train} and a tested by
\link{DaMiR.EnsL_Test}.
}
\details{
This function finds the best model, taking into account specific
classification metrics.
}
\examples{
# use example data:
set.seed(1)
}
\author{
Mattia Chiesa, Luca Piacentini
}
