% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classif_2_Classes_Test.R
\name{DaMiR.EnsL_Test}
\alias{DaMiR.EnsL_Test}
\title{Test Binary Classifiers}
\usage{
DaMiR.EnsL_Test(data, classes, EnsL_model)
}
\arguments{
\item{data}{A SummarizedExperiment object or a data frame/matrix
of normalized expression data. Rows and Cols should be
observations and features, respectively.}

\item{classes}{A class vector with \code{nrow(data)} elements.
Each element represents the class label for each observation.
Two different class labels are allowed. Note. this argument should
not be set when 'data' is a SummarizedExperiment object}

\item{EnsL_model}{A list with the models trained by
\link{DaMiR.EnsL_Train} function.}
}
\value{
A dataframe containing the predictions on the testset
}
\description{
This function tests the models learned by the
\link{DaMiR.EnsL_Train} function, on a test
set
}
\details{
This function implements the test step of
\link{DaMiR.EnsembleLearning2cl} function
}
\examples{
# use example data:
data(selected_features)
data(df)
set.seed(1)
# only for the example:
# speed up the process setting a low 'iter' argument value;
# for real data set use default 'iter' value (i.e. 100) or higher:
#  Tr_res <- DaMiR.EnsL_Train(
#  selected_features,classes=df$class, fSample.tr.w=0.6, iter=3,
# cl_type=c("RF","LR"))
# DaMiR.EnsembleLearning2cl_Test(selected_features,
#classes=df$class,Tr_res)

}
\author{
Mattia Chiesa, Luca Piacentini
}
