% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{lastExonStartPerGroup}
\alias{lastExonStartPerGroup}
\title{Get last start per granges group}
\usage{
lastExonStartPerGroup(grl, keep.names = TRUE)
}
\arguments{
\item{grl}{a \code{\link[GenomicRanges]{GRangesList}}}

\item{keep.names}{a boolean, keep names or not, default: (TRUE)}
}
\value{
a Rle(keep.names = T), or integer vector(F)
}
\description{
Get last start per granges group
}
\examples{
\dontrun{
gr_plus <- GRanges(seqnames = c("chr1", "chr1"),
                   ranges = IRanges(c(7, 14), width = 3),
                   strand = c("+", "+"))
gr_minus <- GRanges(seqnames = c("chr2", "chr2"),
                    ranges = IRanges(c(4, 1), c(9, 3)),
                    strand = c("-", "-"))
grl <- GRangesList(tx1 = gr_plus, tx2 = gr_minus)
lastExonStartPerGroup(grl)
}

}
\references{
Tjeldnes, H., Labun, K., Torres Cleuren, Y. et al.
ORFik: a comprehensive R toolkit for the analysis of translation.
BMC Bioinformatics 22, 336 (2021). DOI: 10.1186/s12859-021-04254-w
}
\author{
Haakon Tjeldnes et al.
}
\keyword{internal}
