% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{get_params}
\alias{get_params}
\title{Estimate zero-inflated negative binomial parameters from a real dataset}
\usage{
get_params(
  counts,
  threshold = NULL,
  size_factor = NULL,
  min_size = NULL,
  scale_p0 = NULL
)
}
\arguments{
\item{counts}{A matrix of counts.}

\item{threshold}{Only estimate parameters from transcripts with row means
greater than this threshold.}

\item{size_factor}{Optional numeric scalar to scale the estimated size
parameters.}

\item{min_size}{Optional numeric value to enforce a minimum size parameter.}

\item{scale_p0}{Optional numeric scalar to scale the zero-inflation
probabilities.}
}
\value{
A list containing:
\describe{
\item{p0}{A vector of probabilities that the count will be zero,
one for each gene/transcript.}
\item{mu}{The estimated negative binomial mean by method of
moments for the non-zero counts.}
\item{size}{The estimated negative binomial size by method of
moments for the non-zero counts.}
\item{fit}{A fit relating log mean to log size for use in
simulating new data.}
}
}
\description{
This function estimates the parameters of a zero-inflated negative binomial
distribution based on a real count data set using the method of moments.
The function also returns a spline fit of log mean to log size which can be
used when generating new simulated data.
}
\author{
Jeff Leek (original), Chun Shen Lim (modifications)
}
\keyword{internal}
