% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{get_lfsr_annotation}
\alias{get_lfsr_annotation}
\title{Retrieve and format adjusted p-value for a specific ORF and contrast}
\usage{
get_lfsr_annotation(rowdata, orf, contrast_name, dou_signif_col = "lfsr")
}
\arguments{
\item{rowdata}{A data frame containing differential results, including
columns for \code{orf_id}, \code{contrast}, and the specified p-value column.}

\item{orf}{A character string specifying the ORF ID to look up.}

\item{contrast_name}{A character string specifying the contrast name
(e.g., "Treatment - Control").}

\item{dou_signif_col}{A character string specifying the column name to
extract the adjusted p-value from. Defaults to \code{"lfsr"}.}
}
\value{
A character string representing the formatted p-value
(e.g., \code{"0.023"}).
}
\description{
This helper function extracts the adjusted p-value (e.g., LFSR or padj)
for a given ORF and contrast from a results data frame, and formats it
to three decimal places. If the value is missing or NA, it returns "N/A".
}
\keyword{internal}
