% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{getDOU}
\alias{getDOU}
\alias{getDOU,DOTSeqDataSets-method}
\alias{getDOU<-}
\alias{getDOU<-,DOTSeqDataSets-method}
\title{Accessor and replacement methods for DOU slot}
\usage{
getDOU(object)

\S4method{getDOU}{DOTSeqDataSets}(object)

getDOU(object) <- value

\S4method{getDOU}{DOTSeqDataSets}(object) <- value
}
\arguments{
\item{object}{A \code{\link{DOTSeqDataSets-class}} object.}

\item{value}{A replacement object (e.g., a \code{\link{DOUData-class}}).}
}
\value{
For the accessor, a \code{\link{DOUData-class}} object. For the replacement,
an updated \code{\link{DOTSeqDataSets-class}} object.
}
\description{
These methods allow access to and replacement of the \code{\link{DOUData-class}}
object stored within a \code{\link{DOTSeqDataSets-class}} container.
}
\examples{
# Read in count matrix, condition table, and annotation files
dir <- system.file("extdata", package = "DOTSeq")

cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

gtf <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

# Create a DOTSeqDataSets object
d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = gtf,
    flattened_bed = bed
)

getDOU(d)

getDTE(d)

}
