% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{getContrasts}
\alias{getContrasts}
\alias{getContrasts,DOUData-method}
\alias{getContrasts,DTEData-method}
\alias{getContrasts,DOTSeqDataSets-method}
\alias{getContrasts<-}
\alias{getContrasts<-,DOUData-method}
\alias{getContrasts<-,DTEData-method}
\title{Access and replace contrast results from post hoc analysis}
\usage{
getContrasts(object, type = c("interaction", "strategy"))

\S4method{getContrasts}{DOUData}(object, type = c("interaction", "strategy"))

\S4method{getContrasts}{DTEData}(object, type = c("interaction", "strategy"))

\S4method{getContrasts}{DOTSeqDataSets}(object, type = c("interaction", "strategy"))

getContrasts(object, type = c("interaction", "strategy")) <- value

\S4method{getContrasts}{DOUData}(object, type = c("interaction", "strategy")) <- value

\S4method{getContrasts}{DTEData}(object, type = c("interaction", "strategy")) <- value
}
\arguments{
\item{object}{A \code{\link{DOUData-class}} or \code{\link{DTEData-class}} object.}

\item{type}{A character string, either \code{"interaction"} or
\code{"strategy"}.}

\item{value}{A \code{DFrame} or \code{data.frame} to replace the
contrast results.}
}
\value{
For the accessor, a \code{DFrame} or \code{data.frame}
containing contrast results. For the replacement, an updated
\code{\link{DOUData-class}}, \code{\link{DTEData-class}} or \code{\link{DOTSeqDataSets-class}} object.
}
\description{
These methods retrieve or replace either interaction-specific or
strategy-specific contrast results from a \code{\link{DOUData-class}},
\code{\link{DTEData-class}}, or \code{\link{DOTSeqDataSets-class}} object.
}
\examples{
# Read in count matrix, condition table, and annotation files
dir <- system.file("extdata", package = "DOTSeq")

cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

flat <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

# Create a DOTSeqDataSets object
d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = flat,
    flattened_bed = bed
)

getDOU(d)

getDTE(d)

}
