% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{calculateUsage}
\alias{calculateUsage}
\title{Calculate ORF usage across conditions from a SummarizedExperiment}
\usage{
calculateUsage(data, gene_id)
}
\arguments{
\item{data}{A \code{\link{DOUData-class}} object containing DOUResults}

\item{gene_id}{A character string specifying the gene ID of interest}
}
\value{
A data.frame with ORF IDs, conditions, and usage estimates
}
\description{
This function extracts post hoc results for a given gene ID and
computes condition-specific ORF usage using emmeans contrasts.
}
\details{
Usage is computed as the inverse logit of the difference between
ribo and RNA strategy emmeans per condition. Only valid emmGrid
objects are used. Strategy levels are assigned using a helper
function \code{\link{assign_strategy_levels}}.
}
\examples{
# Load a required library
library(SummarizedExperiment)

# Load test data
dir <- system.file("extdata", package = "DOTSeq")
cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

flat <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = flat,
    flattened_bed = bed
)

dou <- getDOU(d)

dou <- dou[rowData(dou)$is_kept == TRUE, ]
# Subset only one gene
dou <- dou[rowData(dou)$gene_id == "ENSG00000119402.18", ]
    
getDOU(d) <- dou

d <- DOTSeq(datasets = d, modules = "DOU")

usage_df <- calculateUsage(
    getDOU(d),
    gene_id = "ENSG00000119402.18"
)
print(usage_df)

}
