% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{PostHoc}
\alias{PostHoc}
\title{Construct a PostHoc Object}
\usage{
PostHoc(type = "fitError", results = list(), posthoc = NA_real_)
}
\arguments{
\item{type}{A \code{character(1)} string indicating the model type.
Default is \code{"fitError"}.}

\item{results}{A \code{list} containing model results, parameters, and
test statistics.}

\item{posthoc}{An optional object storing post hoc summary objects
(e.g., from \code{\link[emmeans]{emmeans}}). Default is
\code{NA_real_}.}
}
\value{
A \code{PostHoc} S4 object.
}
\description{
This function constructs a new \code{PostHoc} object, which stores the
results of a statistical model fitted to ORF-level data. It is typically
used internally by the \pkg{DOTSeq} workflow or manually for testing and
diagnostics.
}
\examples{
## Create a dummy PostHoc object
PostHocRes <- PostHoc(
    type = "glmmTMB",
    results = list(x = 3, y = 7, b = 4)
)
PostHocRes

}
