% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{DTEData-class}
\alias{DTEData-class}
\title{DTEData-class}
\description{
A \code{DESeqDataSet} object extended to store modeling
components for Differential Translation Efficiency (DTE) analysis in
the \pkg{DOTSeq} framework.
}
\details{
This class contains raw counts, sample metadata, and additional slots
for the \code{\link[emmeans]{emmeans}} specifications, and contrast
results.

Inherits all slots from \code{DESeqDataSet}, and adds:
\itemize{
\item specs: A \code{formula} object used to generate
\code{\link[emmeans]{emmeans}} specifications for post hoc contrasts.
\item interaction: A \code{DFrame} or \code{data.frame} containing
results interaction-specific contrasts
\item strategy: A \code{DFrame} or \code{data.frame} containing
results strategy-specific contrasts
}
}
\examples{
# Read in count matrix, condition table, and annotation files
dir <- system.file("extdata", package = "DOTSeq")

cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

flat <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

# Create a DOTSeqDataSets object
d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = flat,
    flattened_bed = bed
)

getDOU(d)

getDTE(d)

}
\seealso{
\code{\link[DESeq2]{DESeqDataSet-class}}
}
