% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseAnalyzer.R
\name{gseNCG}
\alias{gseNCG}
\title{NCG Gene Set Enrichment Analysis}
\usage{
gseNCG(
  geneList,
  exponent = 1,
  nPerm = 1000,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE,
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 1000,
  maxPerm = 10000,
  ...
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{exponent}{weight of each step}

\item{nPerm}{permutation numbers}

\item{minGSSize}{minimal size of genes annotated by ontology term for testing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{verbose}{print message or not}

\item{method}{method of GSEA, one of "multilevel", "permute", "sample"}

\item{adaptive}{logical, use adaptive permutation or not (default: FALSE)}

\item{minPerm}{minimum number of permutations for adaptive mode (default: 1000)}

\item{maxPerm}{maximum number of permutations for adaptive mode (default: 10000)}

\item{...}{other parameter}
}
\value{
gseaResult object
}
\description{
perform gsea analysis
}
\author{
Guangchuang Yu
}
\keyword{manip}
