% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{optimizedLambda}
\alias{optimizedLambda}
\alias{optimizedLambda<-}
\alias{optimizedLambda,DNEA-method}
\alias{optimizedLambda<-,DNEA-method}
\title{Access the lambda value used in analysis}
\usage{
optimizedLambda(x)

optimizedLambda(x) <- value

\S4method{optimizedLambda}{DNEA}(x)

\S4method{optimizedLambda}{DNEA}(x) <- value
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}

\item{value}{a single-value numeric vector corresponding to the lambda
value to use in analysis.}
}
\value{
The optimized lambda hyperparameter.
}
\description{
The function takes as input a \code{\link{DNEA}} object and returns
the hyper parameter (lambda) that is currently being used for the analysis.
The user may also provide a single-value numeric vector to change the
lambda value for analysis.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

optimizedLambda(dnw) <- 0.15
optimizedLambda(dnw)
}
\seealso{
\code{\link{BICtune}}
}
\author{
Christopher Patsalis
}
