% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{numFeatures}
\alias{numFeatures}
\alias{numFeatures,DNEA-method}
\alias{numFeatures,DNEAinputSummary-method}
\title{Retrieve the total number of features in the dataset}
\usage{
numFeatures(x)

\S4method{numFeatures}{DNEA}(x)

\S4method{numFeatures}{DNEAinputSummary}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}
}
\value{
The number of features in the data set.
}
\description{
This function prints to console the total number of
features in the data set
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

numFeatures(dnw)
}
\seealso{
\code{\link{createDNEAobject}}
}
\author{
Christopher Patsalis
}
