% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primary.R
\name{getNetworks}
\alias{getNetworks}
\title{Construct the GLASSO-based biological Networks}
\usage{
getNetworks(
  object,
  lambda_values,
  aprox = FALSE,
  informed = TRUE,
  interval = 0.001,
  assay,
  eps_threshold = 1e-06,
  eta_value = 0.1,
  optimal_lambdas,
  BPPARAM = bpparam(),
  BPOPTIONS = bpoptions()
)
}
\arguments{
\item{object}{A \code{\link[=DNEA-class]{DNEA}} object.}

\item{lambda_values}{\strong{OPTIONAL} A list of values to test while optimizing
the lambda parameter. If not provided, a set of lambda values are chosen
based on the theoretical value for the asymptotically valid lambda. More
information about this can be found in the details section of
\code{\link{BICtune}}.}

\item{aprox}{TRUE/FALSE indicating whether \code{\link{BICtune}}
should be used to optimize the lambda value for each condition. If
\code{aprox==FALSE}, sqrt(log(# features)/#samples) is used to approximate
lambda.}

\item{informed}{TRUE/FALSE indicating whether the asymptotic properties
of lambda for large data sets should be utilized to tune the parameter.
This reduces the necessary number of computations for optimization.}

\item{interval}{A numeric value indicating the specifity by which to
optimize lambda. The default value is 1e-3, which indicates lambda will
be optimized to 3 decimal places. The value should be between 0 and 0.1.}

\item{assay}{A character string indicating which expression assay to
use for analysis. The default is the "log_scaled_data" assay that is
created during \code{\link{createDNEAobject}}.}

\item{eps_threshold}{A numeric value between 0 and 1 by which to
threshold the partial correlation values for edge identification.
Edges with an absolute partial correlation value below this
threshold will be zero'd out from the adjacency matrix.}

\item{eta_value}{A tuning parameter that that ensures that the empirical
covariance matrix of the data is positive definite so that we can
calculate its inverse. The default value is 0.01.}

\item{optimal_lambdas}{\emph{\strong{OPTIONAL -}} The lambda value
to be used in analysis. If not provided, the lambda value is
determined based on the input of the "aprox" parameter.}

\item{BPPARAM}{A \code{\link{BiocParallel}} object.}

\item{BPOPTIONS}{a list of options for BiocParallel created using
the \code{\link[BiocParallel:bpoptions]{bpoptions}} function.}
}
\value{
A \code{\link[=DNEA-class]{DNEA}} object after populating
the adjaceny_matrix and edge_list slots with the corresponding
adjacency_matrix for each sample condition as well as the network
edge list.
}
\description{
This function constructs a biological network for each experimental
condition using the joint estimation method described
in Ma et al. (2019) (\emph{please see references below}). If
\code{\link{stabilitySelection}} was performed previously,
the selection probabilities will be used to for model optimization
when constructing the networks (please see the \strong{\emph{Details}}
section of \code{\link{stabilitySelection}} for more information).
}
\examples{
#dnw is a \code{\link[=DNEA-class]{DNEA}} object with the results
#generated for the example data accessed by running
#data(TEDDY) in the console. The workflow for this data
#can be found in the vignette accessed by running
#browseVignettes("DNEA") in the console.
data(dnw)

#construct the networks
dnw <- getNetworks(object=dnw, aprox = TRUE)

#now we can plot the group networks
plotNetworks(object=dnw, type="group_networks")

}
\references{
Ma J, Karnovsky A, Afshinnia F, Wigginton J, Rader DJ, Natarajan L,
Sharma K, Porter AC, Rahman M, He J, Hamm L, Shafi T, Gipson D,
Gadegbeku C, Feldman H, Michailidis G, Pennathur S.
Differential network enrichment analysis reveals novel lipid pathways in
chronic kidney disease. Bioinformatics. 2019 Sep 15;35(18):3441-3452.
doi: 10.1093/bioinformatics/btz114. PMID: 30887029; PMCID: PMC6748777.
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6748777/}

Iyer GR, Wigginton J, Duren W, LaBarre JL, Brandenburg M, Burant C,
Michailidis G, Karnovsky A. Application of Differential Network
Enrichment Analysis for Deciphering Metabolic Alterations. Metabolites.
2020 Nov 24;10(12):479. doi: 10.3390/metabo10120479. PMID: 33255384;
PMCID: PMC7761243. \url{https://pubmed.ncbi.nlm.nih.gov/33255384/}
}
\seealso{
\code{\link{edgeList}},\code{\link{adjacencyMatrix}}
}
\author{
Christopher Patsalis
}
