% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotShape.R
\name{heatShape}
\alias{heatShape}
\title{Plot heatmap of DNA shape features}
\usage{
heatShape(shapeMatrix, nBins, ordRow = NULL, useRaster = TRUE, ... )
}
\arguments{
\item{shapeMatrix}{A matrix containing DNAshape prediction results.}

\item{nBins}{An integer specifying the number of equally-sized bins in which shape predictions should be aggregated. Summarized predictions can be visualized by setting nBins=1.}

\item{ordRow}{A numeric vector (of the same length as the number of rows of shapeMatrix) defining the permutation of the rows of shapeMatrix to be used for plotting. Default to NULL, i.e. rows are ordered by coefficients of variation.}

\item{useRaster}{Logical, if TRUE a bitmap raster is used to plot the image instead of polygons (see ?graphics::image for details).}

\item{...}{Additional parameters to be passed to the image.plot function (see ?fields::image.plot for details).}
}
\value{
Called for its effects
}
\description{
Plot heatmap of DNA shape features
}
\examples{
fn <- system.file("extdata", "CGRsample.fa", package = "DNAshapeR")
pred <- getShape(fn)
library(fields)
heatShape(pred$MGW, 20)
}
\author{
Federico Comoglio
}
\keyword{core}
