% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{getWholeChromosomes}
\alias{getWholeChromosomes}
\title{Get whole chromosomes from methylation data}
\usage{
getWholeChromosomes(methylationData)
}
\arguments{
\item{methylationData}{the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).}
}
\value{
a \code{\link{GRanges}} object will all chromosomes.
}
\description{
Returns a \code{\link{GRanges}} object spanning from the first cytocine until
the last one on each chromosome
}
\examples{
# load the methylation data
data(methylationDataList)

# get all chromosomes
chromosomes <- getWholeChromosomes(methylationDataList[["WT"]])

}
\author{
Nicolae Radu Zabet
}
