% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePMDs.R
\name{filterPMDs}
\alias{filterPMDs}
\title{Filter PMDs}
\usage{
filterPMDs(
  methylationData,
  potentialPMDs,
  context = "CG",
  minCytosinesCount = 4,
  minMethylation = 0.4,
  maxMethylation = 0.6,
  minReadsPerCytosine = 3,
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{methylationData}{the methylation data in condition
(see \code{\link{ontSampleGRangesList}}).}

\item{potentialPMDs}{a \code{\link[GenomicRanges]{GRanges}} object with potential PMDs 
where to compute the PMDs. This can be a a list of gene and/or transposable 
elements coordinates.}

\item{context}{the context in which the PMDs are computed (\code{"CG"}, 
\code{"CHG"} or \code{"CHH"}).}

\item{minCytosinesCount}{PMDs with less cytosines in the specified context 
than \code{minCytosinesCount} will be discarded.}

\item{minMethylation}{Numeric [0,1]; minimum mean methylation proportion.}

\item{maxMethylation}{Numeric [0,1]; maximum mean methylation proportion.}

\item{minReadsPerCytosine}{PMDs with the average number of reads lower than 
\code{minReadsPerCytosine} are discarded.}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
a \code{\link[GenomicRanges]{GRanges}} object with 5 metadata columns that contain 
the PMDs; see \code{\link{computePMDs}}.
}
\description{
This function verifies whether a set of potential PMDs (e.g. genes, 
transposons, CpG islands) are partially methylated or not.
}
\examples{
# load the ONT methylation data 
data(ontSampleGRangesList)
# load the gene annotation data
data(GEs_hg38)

# select the transcript
transcript <- GEs_hg38[which(GEs_hg38$type == "transcript")]

# the regions where to compute the PMDs
regions <- GRanges(seqnames = Rle("chr1"), ranges = IRanges(1E6+5E5,2E6))
transcript <- transcript[overlapsAny(transcript, regions)]

# filter genes that are partially methylated in the two conditions
PMDsGenesCG <- filterPMDs(ontSampleGRangesList[["GM18501"]], 
               potentialPMDs = transcript, 
               context = "CG", minMethylation = 0.4, maxMethylation = 0.6,
               minCytosinesCount = 4, minReadsPerCytosine = 3, cores = 1)

}
\seealso{
\code{\link{PMDsNoiseFilterCG}}, \code{\link{computePMDs}}, 
\code{\link{analyseReadsInsideRegionsForCondition}}  
and \code{\link{mergePMDsIteratively}}
}
\author{
Nicolae Radu Zabet and Young Jun Kim
}
