% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeCoMethylatedRegions.R
\name{computeCoMethylatedRegions}
\alias{computeCoMethylatedRegions}
\title{Compute pairwise co-methylation statistics between regions}
\usage{
computeCoMethylatedRegions(
  methylationData,
  regions,
  minDistance = 500,
  maxDistance = 50000,
  minCoverage = 4,
  pValueThreshold = 0.05,
  correlation_test = "pearson",
  minCorrelation = -0.5,
  maxCorrelation = 0.5,
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{methylationData}{A \code{GRanges} object containing cytosine sites, annotated with
ONT methylation metadata (columns \code{ONT_Cm}, \code{ONT_C}, etc.).}

\item{regions}{A \code{GRanges} object defining genomic regions (e.g., PMDs, Enhancer binding sites) to
evaluate for CMRs.}

\item{minDistance}{Minimum genomic distance (in base pairs) between two regions to be considered (default: 500).}

\item{maxDistance}{Maximum genomic distance (in base pairs) between two regions (default: 50,000).}

\item{minCoverage}{Minimum number of shared reads (per region pair) required to compute correlation (default: 4).}

\item{pValueThreshold}{Significance threshold for FDR-adjusted p-values (default: 0.05).}

\item{correlation_test}{Statistical method to compute correlation; must be one of \code{"pearson"}, \code{"spearman"}, or \code{"kendall"} (default: \code{"pearson"}).}

\item{minCorrelation}{Minimum allowed correlation value for a significant result (must be in between -1 and 0; default: -0.5).}

\item{maxCorrelation}{Maximum allowed correlation value for a significant result (must be in between 0 and 1; default: 0.5).}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
A \code{GInteractions} object, where each row represents a significantly correlated pair of genomic regions
from the input \code{regions}. The anchors of each interaction correspond to original regions,
and their genomic coordinates are retained in the \code{anchor1} and \code{anchor2} slots.

Additionally, a \code{genomic_position} meta-column is included to indicate the original coordinate ranges
(in UCSC/IGV format) for each interaction, aiding downstream interpretation or visualisation.

Each interaction is annotated with:
\describe{
  \item{correlation}{Correlation coefficient between the two regions}
  \item{coverage}{Number of shared reads used for correlation}
  \item{p.value}{FDR-adjusted p-value for the correlation test}
}
}
\description{
\code{computeCoMethylatedRegions()} calculates pairwise correlation statistics for methylation levels
across defined genomic regions (e.g., PMDs, Enhancer binding sites). For each region pair within the
specified distance range, the function computes per-read methylation proportions and
performs correlation testing (Pearson, Spearman, or Kendall). Pairs with strong correlations
(beyond user-defined thresholds) and significant p-values (FDR-adjusted) are returned.
}
\details{
Compute Co-Methylated Regions (CMRs)


The function first identifies all region pairs within the user-defined distance range. For each pair,
it calculates methylation proportions per read across both regions, extracts common reads,
and tests correlation using the selected method. FDR correction is applied globally across all region pairs.
}
\examples{
# Load methylation data and PMD regions
data("ont_gr_GM18870_chr1_sorted_bins_1k")
data("ont_gr_GM18870_chr1_PMD_bins_1k")

# Compute highly correlated regions (Pearson)
coMethylationRegion_pearson <- computeCoMethylatedRegions(ont_gr_GM18870_chr1_sorted_bins_1k,
                                                          ont_gr_GM18870_chr1_PMD_bins_1k[1:5],
                                                          minDistance = 500,
                                                          maxDistance = 50000,
                                                          minCoverage = 4,
                                                          pValueThreshold = 0.05,
                                                          correlation_test = "pearson",
                                                          minCorrelation = -0.5,
                                                          maxCorrelation = 0.5,
                                                          parallel = FALSE,
                                                          BPPARAM  = NULL)

}
\seealso{
\code{\link{readONTbam}}, \code{\link{computePMDs}},
\code{\link{ontSampleGRangesList}}
}
\author{
Nicolae Radu Zabet and Young Jun Kim
}
