% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/qqDMCs-method.R
\name{qqDMCs-method}
\alias{qqDMCs-method}
\alias{qqDMCs,BSDMCs-method}
\alias{qqDMCs}
\title{qqDMCs method}
\usage{
qqDMCs(object, ...)

\S4method{qqDMCs}{BSDMCs}(object, ...)
}
\arguments{
\item{object}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}
object}

\item{...}{other possible parameters}
}
\value{
A QQ plot
}
\description{
Creates a Q-Q plot based on the p-values obtained
from \code{\link{findDMCs}} method
}
\examples{
set.seed(1980)
nr <- 150; nc <- 8
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n=nr*nc,c(metht),prob = runif(nr*nc)),nr,nc)
r1 <- GRanges(rep('chr1', nr), IRanges(1:nr, width=1), strand='*')
names(r1) <- 1:nr
cd1 <- DataFrame(Group=rep(c('G1','G2'),each=nc/2),row.names=LETTERS[1:nc])
OBJ1 <- cBSData(rowRanges=r1,methReads=methc,totalReads=metht,colData=cd1)
OBJ2 <- methHMEM(OBJ1, MaxK=2, mc.cores=2)
OBJ3 <- methHMMCMC(OBJ2, mc.cores=2)
OBJ4 <- findDMCs(OBJ3, mc.cores=2)
qqDMCs(OBJ4)
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
