% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/cBSDMCs-method.R
\name{cBSDMCs-method}
\alias{cBSDMCs-method}
\alias{cBSDMCs,matrix,matrix,matrix,matrix,matrix,GRanges-method}
\alias{cBSDMCs}
\title{cBSDMCs method}
\usage{
cBSDMCs(
  methReads,
  totalReads,
  methLevels,
  methStates,
  methVars,
  rowRanges,
  colData = DataFrame(row.names = colnames(methReads)),
  metadata = list(),
  ...
)

\S4method{cBSDMCs}{matrix,matrix,matrix,matrix,matrix,GRanges}(
  methReads,
  totalReads,
  methLevels,
  methStates,
  methVars,
  rowRanges,
  colData = DataFrame(row.names = colnames(methReads)),
  metadata = list(),
  ...
)
}
\arguments{
\item{methReads}{The matrix \code{methReads} contains the number of
methylated reads spanning a CpG-site. The rows represent the CpG sites in
\code{rowRanges} and the columns represent the samples in \code{colData}.}

\item{totalReads}{The matrix \code{totalReads} contains the number of reads
spanning a CpG-site. The rows represent the CpG sites in \code{rowRanges}
and the columns represent the samples in \code{colData}.}

\item{methLevels}{The matrix \code{methLevels} contains the predicted
methylation level spanning a CpG-site using Hidden Markov model. The rows
represent the CpG sites in \code{rowRanges} and the columns represent the
samples in \code{colData}.}

\item{methStates}{The matrix \code{methStates} contains the state of
methylation obtained from Hidden Markov model spanning a CpG-site. The rows
represent the CpG sites in \code{rowRanges} and the columns represent the
samples in \code{colData}. The value of state is stored in \code{metadata},
named \code{Beta}.}

\item{methVars}{The matrix \code{methVars} contains the variances of the
corresponding \code{methLevels} obtianed from MCMC.}

\item{rowRanges}{A \code{\link{GRanges}} or \code{\link{GRangesList}}
object describing the ranges of interest. Names, if present, become the row
names of the \code{\link{SummarizedExperiment}} object. The length of the
\code{\link{GRanges}} or \code{\link{GRangesList}} must equal the number of
rows of the matrices in \code{assays}. If \code{rowRanges} is missing, a
\code{\link{SummarizedExperiment}} instance is returned.}

\item{colData}{Object of class \code{"DataFrame"} containing information on
variable values of the samples}

\item{metadata}{An optional \code{list} of arbitrary content describing the
overall experiment}

\item{...}{other possible parameters}
}
\value{
A \code{\link{BSDMCs-class}}
}
\description{
Creates a \code{\link{BSDMCs-class}} object
}
\details{
The rows of a \code{BSDMCs} object represent ranges (in genomic
coordinates) of interest. The ranges of interest are described by a
\code{GRanges} or a \code{GRangesList} object,
accessible using the \code{rowRanges} function.
The \code{GRanges} and \code{GRangesList} classes
contains sequence (e.g., chromosome) name, genomic coordinates, and strand
information. Each range can be annotated with additional data; this data
might be used to describe the range or to
summarize results (e.g., statistics of differential abundance) relevant to
the range. Rows may or may not have row names; they often will not.
}
\examples{
set.seed(1980)
nr <- 150; nc <- 8
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n=nr*nc,c(metht),prob = runif(nr*nc)),nr,nc)
meths <- matrix(as.integer(runif(nr * nc, 0, 10)), nr)
methl <- methc/metht
methv <- matrix((runif(nr * nc, 0.1, 0.5)), nr)
r1 <- GRanges(rep('chr1', nr), IRanges(1:nr, width=1), strand='*')
names(r1) <- 1:nr
cd1 <- DataFrame(Group=rep(c('G1','G2'),each=nc/2),row.names=LETTERS[1:nc])
OBJ2 <- cBSDMCs(rowRanges=r1,methReads=methc,totalReads=metht,
methLevels=methl,methStates=meths,methVars=methv,colData=cd1)
OBJ2
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
