% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator_base.R
\name{simulator_base}
\alias{simulator_base}
\title{Composition size simulator}
\usage{
simulator_base(
  totals_cond1,
  totals_cond2,
  dirichlet_s1,
  dirichlet_s2,
  similarity_mat = NULL
)
}
\arguments{
\item{totals_cond1}{A vector of integers (n_rep1, ) for the total samples in
each replicate in codition 1}

\item{totals_cond2}{A vector of integers (n_rep2, ) for the total samples in
each replicate in codition 2}

\item{dirichlet_s1}{A vector of floats (n_cluster, ) for the composition
concentration in condition 1}

\item{dirichlet_s2}{A vector of floats (n_cluster, ) for the composition
concentration in condition 2}

\item{similarity_mat}{A matrix of floats (n_cluster, n_cluster) for the
similarity matrix between each cluster pair}
}
\value{
a list of two matrices for composition sizes in each replicate and
  each cluster in both conditions.
}
\description{
Directly simulating the composition size from a Dirichlet-Multinomial
distribution with replicates for two conditions.
}
\examples{
K <- 2
totals1 = c(100, 800, 1300, 600)
totals2 = c(250, 700, 1100)
diri_s1 = rep(1, K) * 20
diri_s2 = rep(1, K) * 20
confuse_rate = 0.2
simil_mat = create_simMat(2, 0.2)
sim_dat <- simulator_base(totals1, totals2, diri_s1, diri_s2, simil_mat)

}
