% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_EM.R
\name{multinom_EM}
\alias{multinom_EM}
\title{An EM algorithm to fit a multinomial with maximum likelihood}
\usage{
multinom_EM(X, simMM, min_iter = 10, max_iter = 1000, logLik_threshold = 0.01)
}
\arguments{
\item{X}{A vector of commopent sizes}

\item{simMM}{A matrix of floats (n_cluster, n_cluster) for the similarity
matrix between clusters. simMM[i,j] means the proportion of cluster i will
be assigned to cluster j, hence colSums(simMM) are ones.}

\item{min_iter}{integer(1). number of minimum iterations}

\item{max_iter}{integer(1). number of maximum iterations}

\item{logLik_threshold}{A float. The threshold of logLikelihood increase for
detecting convergence}
}
\value{
a list containing \code{mu}, a vector for estimated latent proportion
  of each cluster, \code{logLik}, a float for the estimated log likelihood,
  \code{simMM}, the input of simMM, code{X}, the input of X, \code{X_prop},
  the proportion of clusters in the input X, \code{predict_X_prop}, and the
  predicted proportion of clusters based on mu and simMM.
}
\description{
An EM algorithm to fit a multinomial with maximum likelihood
}
\examples{
X = c(100, 300, 1500, 500, 1000)
simMM = create_simMat(5, confuse_rate=0.2)
multinom_EM(X, simMM)

}
