% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_tracks.R
\name{dame_track}
\alias{dame_track}
\title{Plot score tracks}
\usage{
dame_track(
  dame,
  window = 0,
  positions = 0,
  derASM = NULL,
  ASM = NULL,
  colvec = NULL,
  plotSNP = FALSE
)
}
\arguments{
\item{dame}{GRanges object containing a region of interest, or detected with
find_dames}

\item{window}{Number of CpG sites outside (up or down-stream) of the DAME
should be plotted. Default = 0.}

\item{positions}{Number of bp sites outside (up or down-stream) of the DAME
should be plotted. Default = 0.}

\item{derASM}{SummarizedExperiment object obtained from calc_derivedasm
(Filtering should be done by the user)}

\item{ASM}{SummarizedExperiment object obtained from calc_asm (Filtering
should be done by the user)}

\item{colvec}{Vector of colors (mainly useful for the SNP plot, because I add
it with cowplot, so I don't export a ggplot, optional)}

\item{plotSNP}{whether to add the SNP track, only if derASM is specified.
Default = FALSE}
}
\value{
Plot
}
\description{
Plot score tracks
}
\examples{
library(GenomicRanges)
DAME <- GRanges(19, IRanges(306443,310272))
data('readtuples_output')
ASM <- calc_asm(readtuples_output)
SummarizedExperiment::colData(ASM)$group <- c(rep('CRC',3),rep('NORM',2))
SummarizedExperiment::colData(ASM)$samples <- colnames(ASM)
dame_track(dame = DAME, 
           ASM = ASM) 

}
