% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_derivedasm.R
\name{calc_derivedasm}
\alias{calc_derivedasm}
\title{Calculate SNP-based ASM}
\usage{
calc_derivedasm(sampleList, cores = 1, verbose = TRUE)
}
\arguments{
\item{sampleList}{List of samples returned from \code{\link{extract_bams}}.}

\item{cores}{Number of cores to thread.}

\item{verbose}{If the function should be verbose.}
}
\value{
\code{RangedSummarizedExperiment} containing in assays:
\itemize{
\item der.ASM: matrix with SNP-based ASM
\item snp.table: Matrix with SNP associated to the CpG site.
\item ref.cov: Coverage of the 'reference' allele.
\item alt.cov: Coevarage of the 'alternative' allele.
\item ref.meth: Methylated reads from the 'reference' allele.
\item alt.meth: Methylated reads from the 'alternative' allele.
}
}
\description{
Combines all the \code{GRangeslist} generated in \code{\link{extract_bams}}
into a \code{\link{RangedSummarizedExperiment}} object, and calculates
SNP-based allele-specific methylation.
}
\examples{
data(extractbams_output)
derASM <- calc_derivedasm(extractbams_output[c(1,2)], cores = 1, 
   verbose = FALSE)

}
