% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{runCompensation}
\alias{runCompensation}
\title{compensate with additional options}
\usage{
runCompensation(obj, spillover, updateChannelNames = TRUE)
}
\arguments{
\item{obj}{a flowCore::flowFrame or flowCore::flowSet}

\item{spillover}{compensation object or spillover matrix or a list of
compensation objects}

\item{updateChannelNames}{if TRUE, add a 'comp-' prefix to all fluorochrome
channels (hence does not impact the columns related to FSC, SSC, or other
specific keyword like TIME, Original_ID, File,...)
Default TRUE.}
}
\value{
a new object with compensated data, and possibly updated column names
}
\description{
: this is a simple wrapper around the flowCore::compensate()
utility, allowing to trigger an update of the fluo channel names
with a prefix 'comp-' (as in FlowJo)
}
\examples{

data(OMIP021Samples)

ff <- OMIP021Samples[[1]]
compMatrix <- flowCore::spillover(ff)$SPILL
ff <- runCompensation(ff, 
                      spillover = compMatrix, 
                      updateChannelNames = TRUE)

}
