% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoPipeline-functions.R
\name{interactingWithCytoPipelineCache}
\alias{interactingWithCytoPipelineCache}
\alias{deleteCytoPipelineCache}
\alias{buildCytoPipelineFromCache}
\alias{checkCytoPipelineConsistencyWithCache}
\title{interaction between CytoPipeline object and disk cache}
\usage{
deleteCytoPipelineCache(x, path = ".")

buildCytoPipelineFromCache(experimentName, path = ".")

checkCytoPipelineConsistencyWithCache(
  x,
  path = ".",
  whichQueue = c("both", "scale transform", "pre-processing"),
  sampleFile = NULL
)
}
\arguments{
\item{x}{a CytoPipeline object}

\item{path}{the full path to the experiment storage on disk
(without the /.cache)}

\item{experimentName}{the experimentName used to select the file cache on
disk}

\item{whichQueue}{which processing queue to check the consistency of}

\item{sampleFile}{if whichQueue == "pre-processing" or "both": which sample
file(s) to check on the disk cache}
}
\value{
for \code{deleteCytoPipelineCache}: TRUE if successfully removed\cr
for \code{buildCytoPipelineFromCache}: the built CytoPipeline object\cr
for \code{checkCytoPipelineConsistencyWithCache}: a list with the following
values:
\itemize{
\item \code{isConsistent} (TRUE/FALSE)
\item \code{inconsistencyMsg}: character filled in
by an inconsistency message in case the cache and
CytoPipeline object are not consistent with each other
\item \code{scaleTransformStepStatus}: a character vector,
containing, for each scale transform step, a status
from c("run", "not run", "inconsistent")
\item \code{preProcessingStepStatus}: a character matrix,
containing, for each pre-processing step (rows),
for each sample file (columns), a status from
c("run", "not run", "inconsistent")
}
}
\description{
functions supporting the interaction between a CytoPipeline
object and the file cache on disk
}
\section{Functions}{
\itemize{
\item \code{deleteCytoPipelineCache()}: delete the whole disk cache
corresponding to the experiment of a CytoPipeline object

\item \code{buildCytoPipelineFromCache()}: builds a new CytoPipeline
object,
based on the information stored in the file cache

\item \code{checkCytoPipelineConsistencyWithCache()}: check the consistency
between the processing steps described in a CytoPipeline object,
and what is stored in the file cache

}}
\examples{

# preliminary run:
# build CytoPipeline object using json input, run and store results in cache
rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- file.path(rawDataDir, list.files(rawDataDir,
                                             pattern = "Donor"))
                                             
jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")
outputDir <- base::tempdir()
pipL <- CytoPipeline(jsonPath,
                     experimentName = experimentName,
                     sampleFiles = sampleFiles)

# note we temporarily set working directory into package root directory
# needed as json path mentions "./" path for sample files
suppressWarnings(execute(pipL, rmCache = TRUE, path = outputDir))
     

# rebuild CytoPipeline from stored results in cache, for a specific 
# experiment

experimentName <- "OMIP021_PeacoQC"
pipL2 <- buildCytoPipelineFromCache(
    experimentName = experimentName,
    path = outputDir)


# checking consistency between CytoPipeline object and cache
res <- checkCytoPipelineConsistencyWithCache(pipL2)
#res

suppressWarnings(execute(pipL2, rmCache = FALSE, path = outputDir))
# (everything is already stored in cache)

# deleting cache related to a specific experiment
pipL3 <- CytoPipeline(experimentName = experimentName)
deleteCytoPipelineCache(pipL3, path = outputDir)

}
