% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{updateMarkerName}
\alias{updateMarkerName}
\title{update marker name of a given flowFrame channel}
\usage{
updateMarkerName(ff, channel, newMarkerName)
}
\arguments{
\item{ff}{a flowCore::flowFrame}

\item{channel}{the channel for which to update the marker name}

\item{newMarkerName}{the new marker name to be given to the selected channel}
}
\value{
a new flowCore::flowFrame with the updated marker name
}
\description{
: in a flowCore::flowFrame, update the marker name (stored in
'desc' of parameters data) of a given channel.
Also update the corresponding keyword in the flowFrame.
}
\examples{

data(OMIP021Samples)

retFF <- updateMarkerName(OMIP021Samples[[1]],
                          channel = "FSC-A",
                          newMarkerName = "Fwd Scatter-A")

}
