% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoProcessingStepImplementations.R
\name{compensateFromMatrix}
\alias{compensateFromMatrix}
\title{compensation of fcs file(s) from matrix}
\usage{
compensateFromMatrix(
  x,
  matrixSource = c("fcs", "import"),
  matrixPath = NULL,
  updateChannelNames = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{flowCore::flowFrame} or \code{flowCore::flowSet}}

\item{matrixSource}{if "fcs", the compensation matrix will be fetched from
the fcs files (different compensation matrices can then be applied by fcs
file)
if "import", uses \code{matrixPath} to read the matrix (should be a csv file)}

\item{matrixPath}{if matrixSource == "import", will be used as the input csv
file path}

\item{updateChannelNames}{if TRUE, updates the fluo channel names by
prefixing them with "comp-"}

\item{verbose}{if TRUE, displays information messages}

\item{...}{additional arguments (not used)}
}
\value{
the compensated flowSet or flowFrame
}
\description{
executes the classical compensation function on a flowSet or
flowFrame, given a compensation matrix. The matrix can be either retrieved
in the fcs files themselves or provided as a csv file.
}
\examples{

rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
sampleFiles <-
    file.path(rawDataDir, list.files(rawDataDir, pattern = "Donor"))

truncateMaxRange <- FALSE
minLimit <- NULL

# create flowCore::flowSet with all samples of a dataset
fsRaw <- readSampleFiles(
    sampleFiles = sampleFiles,
    whichSamples = "all",
    truncate_max_range = truncateMaxRange,
    min.limit = minLimit)

suppressWarnings(ff_m <- removeMarginsPeacoQC(x = fsRaw[[2]]))
    
ff_c <-
    compensateFromMatrix(ff_m,
                         matrixSource = "fcs")        
}
