% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotScaleTransformedChannel}
\alias{plotScaleTransformedChannel}
\title{Plot a flow frame in 1D with explicit user given scale transform}
\usage{
plotScaleTransformedChannel(
  ff,
  channel,
  applyTransform = c("axis scale only", "data"),
  transfoType = c("linear", "logicle"),
  linA,
  linB,
  t,
  m,
  w,
  a
)
}
\arguments{
\item{ff}{the \code{flowFrame} to be plotted}

\item{channel}{the name of the channel of which to display the marginal
distribution (i.e. the channel name used as column in the ff expression
matrix).}

\item{applyTransform}{if "data", data are explicitly transformed using
the user provided sclae transformation parameters, before display
if "axis scale only" (default), the data are not transformed,
i.e. only the x axis scale is defined according to
the scale transformation parameters.}

\item{transfoType}{the transformation type, currently only
\code{linear} and \code{logicle}(bi-exponential) are supported.}

\item{linA}{the intercept parameter of the linear transformation.}

\item{linB}{the slope parameter of the linear transformation.}

\item{t}{the max scale parameter of the logicle tranformation.}

\item{m}{the number of positive decades of the logicle tranformation.}

\item{w}{the width parameter of the logicle transformation.}

\item{a}{the number of additional decades on the negative side
for the logicle transformation.}
}
\value{
a ggplot object
}
\description{
This function plots a 1D view, i.e. the marginal distribution
for one specified channel, of the given flow frame, using the specific
user-provided scale transformation parameters.
}
\examples{
# run CytoPipeline object first

outputDir <- base::tempdir()


rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- 
    file.path(
        rawDataDir, 
        list.files(rawDataDir, pattern = "Donor"))
jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")

pipL2 <- CytoPipeline(
    jsonPath,
    experimentName = experimentName,
    sampleFiles = sampleFiles)

suppressWarnings(execute(
    pipL2,
    rmCache = TRUE,
    path = outputDir))

ff <- CytoPipeline::getCytoPipelineFlowFrame(
pipL2,
path = outputDir,
whichQueue = "scale transform",
objectName = "flowframe_aggregate_obj"
)

plotScaleTransformedChannel(
    ff,
    channel = "FSC-A",
    transfoType = "linear",
    linA = 0.0002,
    linB = -0.5)

plotScaleTransformedChannel(
    ff,
    channel = "Comp-670/30Violet-A",
    transfoType = "logicle",
    t = 262144,
    m = 4.5,
    w = 0.5,
    a = 1.0
)

plotScaleTransformedChannel(
    ff,
    channel = "CD3",
    applyTransform = "data",
    transfoType = "logicle",
    t = 262144,
    m = 4.5,
    w = 0.5,
    a = 1.0
)

}
