% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotDiffFlowFrame}
\alias{plotDiffFlowFrame}
\title{Plot the difference plot between two flow frames
from a CytoPipeline run}
\usage{
plotDiffFlowFrame(
  experimentNameFrom,
  experimentNameTo,
  whichQueueFrom,
  whichQueueTo,
  sampleFileFrom,
  sampleFileTo,
  path,
  flowFrameNameFrom,
  flowFrameNameTo,
  xChannelLabelFrom,
  xChannelLabelTo,
  yChannelLabelFrom,
  yChannelLabelTo,
  interactive = FALSE,
  useAllCells,
  nDisplayCells,
  useFixedLinearRange,
  linearRange,
  transfoListName = " "
)
}
\arguments{
\item{experimentNameFrom}{the experiment name (representing a pipeline run)
from which to extract the flow frame ('from' situation)}

\item{experimentNameTo}{the experiment name (representing a pipeline run)
from which to extract the flow frame ('to' situation)}

\item{whichQueueFrom}{"pre-processing" or "scale transform"
('from' situation)}

\item{whichQueueTo}{"pre-processing" or "scale transform"
('to' situation)}

\item{sampleFileFrom}{in case 'whichQueueFrom' is set to 'pre-processing,
which sample file to look at for the 'from' situation.
This can be a number or a character.
\itemize{
\item if whichQueueFrom == "scale transform", the sampleFileFrom is ignored
\item if NULL and whihQueueFrom == "pre-processing", the sampleFileFrom
is defaulted to the first one belonging to the experiment
}}

\item{sampleFileTo}{same as sampleFileFrom, but for the 'to' situation}

\item{path}{the root path to look for the CytoPipeline experiment cache}

\item{flowFrameNameFrom}{for the 'from' situation,
the name of the object to fetch (as referenced in the pipeline workflow)}

\item{flowFrameNameTo}{for the 'to' situation,
the name of the object to fetch (as referenced in the pipeline workflow)}

\item{xChannelLabelFrom}{the label of the channel
to be displayed on the x axis:
the conventional syntax is : \code{channelName} + " - " + \code{channelMarker}}

\item{xChannelLabelTo}{should be equal to xChannelLabelFrom
(otherwise no plot is returned but NULL)}

\item{yChannelLabelFrom}{the label of the channel
to be displayed on the y axis:
the conventional syntax is : \code{channelName} + " - " + \code{channelMarker}}

\item{yChannelLabelTo}{should be equal to yChannelLabelFrom
(otherwise no plot is returned but NULL)}

\item{interactive}{if TRUE, uses ggplot_shiny}

\item{useAllCells}{if TRUE, no subsampling will be done}

\item{nDisplayCells}{if useAllCells == FALSE, the number of subsampled cells}

\item{useFixedLinearRange}{if TRUE, all channels using a linear scale will
use a fixed range set by linearRange}

\item{linearRange}{set for all channels using a linear scale,
if useFixedLinearRange == TRUE}

\item{transfoListName}{if not set to " ", the transformation list
(as an object name ending with "_obj", as referenced in the pipeline
workflow) to be used for for display.}
}
\value{
a ggplot (or plotly if interactive = TRUE) object
}
\description{
Based on an experiment name, this function will gather the
required flowFrames from the CytoPipeline disk cache and display
a difference plot using the user chosen 1D or 2D view.
}
\examples{

# run CytoPipeline object first

outputDir <- base::tempdir()


rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- 
    file.path(
        rawDataDir, 
        list.files(rawDataDir, pattern = "Donor"))
jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")

pipL2 <- CytoPipeline(
    jsonPath,
    experimentName = experimentName,
    sampleFiles = sampleFiles)

suppressWarnings(execute(
    pipL2,
    rmCache = TRUE,
    path = outputDir))


plotDiffFlowFrame(
    experimentNameFrom = experimentName,
    whichQueueFrom = "pre-processing",
    sampleFileFrom = 1,
    flowFrameNameFrom = "remove_doublets_obj",
    xChannelLabelFrom = "FSC-A : NA",
    yChannelLabelFrom = "SSC-A : NA",
    path = outputDir,
    experimentNameTo = experimentName,
    whichQueueTo = "pre-processing",
    sampleFileTo = 1,
    flowFrameNameTo = "remove_debris_obj",
    xChannelLabelTo = "FSC-A : NA",
    yChannelLabelTo = "SSC-A : NA",
    useAllCells = TRUE,
    nDisplayCells = 0,
    useFixedLinearRange = TRUE,
    linearRange = c(-100, 262144))

plotDiffFlowFrame(
    experimentNameFrom = experimentName,
    whichQueueFrom = "pre-processing",
    sampleFileFrom = 1,
    flowFrameNameFrom = "remove_doublets_obj",
    xChannelLabelFrom = "FSC-A : NA",
    yChannelLabelFrom = "SSC-A : NA",
    path = outputDir,
    experimentNameTo = experimentName,
    whichQueueTo = "pre-processing",
    sampleFileTo = 1,
    flowFrameNameTo = "remove_debris_obj",
    xChannelLabelTo = "FSC-A : NA",
    yChannelLabelTo = "SSC-A : NA",
    useAllCells = FALSE,
    nDisplayCells = 100,
    useFixedLinearRange = FALSE,
    linearRange = NULL)

plotDiffFlowFrame(
    experimentNameFrom = experimentName,
    whichQueueFrom = "pre-processing",
    sampleFileFrom = 1,
    flowFrameNameFrom = "remove_debris_obj",
    xChannelLabelFrom = "FSC-A : NA",
    yChannelLabelFrom = "Comp-525/50Violet-A : L/D Aqua - Viability",
    path = outputDir,
    experimentNameTo = experimentName,
    whichQueueTo = "pre-processing",
    sampleFileTo = 1,
    flowFrameNameTo = "remove_dead_cells_obj",
    xChannelLabelTo = "FSC-A : NA",
    yChannelLabelTo = "Comp-525/50Violet-A : L/D Aqua - Viability",
    useAllCells = TRUE,
    nDisplayCells = 0,
    useFixedLinearRange = FALSE,
    linearRange = NULL,
    transfoListName = "scale_transform_estimate_obj")   

}
