% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{EMDDist}
\alias{EMDDist}
\title{Calculate Earth Mover's distance between two samples}
\usage{
EMDDist(
  x1,
  x2,
  channels = NULL,
  binSize = 0.05,
  minRange = -10,
  maxRange = 10,
  returnAll = FALSE
)
}
\arguments{
\item{x1}{can be either a flowCore::flowFrame,
or an expression matrix}

\item{x2}{can be either a flowCore::flowFrame,
or an expression matrix}

\item{channels}{which channels (integer index(ices) or character(s)):
\itemize{
\item if it is a character vector,
it can refer to either the channel names, or the marker names if x1 and x2
have been provided as flowCore::flowFrame
\item if it is a numeric vector,
it refers to the indexes of channels in \code{x1}
\item if NULL : if \code{x1} and \code{x2} are provided as flowCore::flowFrames,
all scatter and fluorescent channels of \code{x1} will be selected;
if \code{x1} and \code{x2} are provided as expression matrices, all colnames of \code{x1}
will be selected.
}}

\item{binSize}{size of equal bins to approximate
the marginal distributions.}

\item{minRange}{minimum value taken
when approximating the marginal distributions}

\item{maxRange}{maximum value taken
when approximating the marginal distributions}

\item{returnAll}{If \code{TRUE}, distributions and marginal distribution
distances are returned as well. Default = \code{FALSE}.}
}
\value{
the Earth Mover's distance between \code{x1} and \code{x2},
which is calculated by summing up all EMD approximates for
the marginal distributions of each channel
}
\description{
Calculate Earth Mover's distance between two samples
}
\examples{

library(CytoPipeline)

data(OMIP021Samples)

# estimate scale transformations 
# and transform the whole OMIP021Samples

transList <- estimateScaleTransforms(
    ff = OMIP021Samples[[1]],
    fluoMethod = "estimateLogicle",
    scatterMethod = "linearQuantile",
    scatterRefMarker = "BV785 - CD3")

OMIP021Trans <- CytoPipeline::applyScaleTransforms(
    OMIP021Samples, 
    transList)

# distance with itself (all channels at once)
# => should return 0
dist0 <- EMDDist(
    x1 = OMIP021Trans[[1]],
    x2 = OMIP021Trans[[1]])

# returning only distance, 2 channels
dist1 <- EMDDist(
    x1 = OMIP021Trans[[1]], 
    x2 = OMIP021Trans[[2]], 
    channels = c("FSC-A", "SSC-A"))

# using only one channel, passed by marker name
dist2 <- EMDDist(x1 = OMIP021Trans[[1]], 
                 x2 = OMIP021Trans[[2]], 
                 channels = c("BV785 - CD3"))

# using only one channel, passed by index
dist3 <- EMDDist(x1 = OMIP021Trans[[1]], 
                 x2 = OMIP021Trans[[2]], 
                 channels = 10)

dist2 == dist3

}
