% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoglm.R
\name{cytoglm}
\alias{cytoglm}
\title{Fit GLM with bootstrap resampling}
\usage{
cytoglm(
  df_samples_subset,
  protein_names,
  condition,
  group = "donor",
  covariate_names = NULL,
  cell_n_min = Inf,
  cell_n_subsample = 0,
  num_boot = 100,
  num_cores = 1
)
}
\arguments{
\item{df_samples_subset}{Data frame or tibble with proteins counts,
cell condition, and group information}

\item{protein_names}{A vector of column names of protein to use in the
analysis}

\item{condition}{The column name of the condition variable}

\item{group}{The column name of the group variable}

\item{covariate_names}{The column names of covariates}

\item{cell_n_min}{Remove samples that are below this cell counts threshold}

\item{cell_n_subsample}{Subsample samples to have this maximum cell count}

\item{num_boot}{Number of bootstrap samples}

\item{num_cores}{Number of computing cores}
}
\value{
A list of class \code{cytoglm} containing
  \item{tb_coef}{coefficent table}
  \item{df_samples_subset}{possibly subsampled df_samples_subset table}
  \item{protein_names}{input protein names}
  \item{condition}{input condition variable}
  \item{group}{input group names}
  \item{covariate_names}{input covariates}
  \item{cell_n_min}{input cell_n_min}
  \item{cell_n_subsample}{input cell_n_subsample}
  \item{unpaired}{true if unpaired samples were provided as input}
  \item{num_boot}{input num_boot}
  \item{num_cores}{input num_cores}
  \item{formula_str}{formula use in the regression model}
}
\description{
Fit GLM with bootstrap resampling
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
glm_fit <- CytoGLMM::cytoglm(df,
                             protein_names = protein_names,
                             condition = "condition",
                             group = "donor",
                             num_boot = 10) # in practice >=1000
glm_fit
}
