% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqsToAln.R
\name{.invertKeepRanges}
\alias{.invertKeepRanges}
\alias{.checkRelativeLocs}
\alias{.adjustRelativeInsLocs}
\alias{.offsetIndices}
\title{Helper functions for selectAlnRegions}
\usage{
.invertKeepRanges(target, keep)

.checkRelativeLocs(target, keep)

.adjustRelativeInsLocs(target, keep, starts, gap_nchars)

.offsetIndices(x, offset)
}
\arguments{
\item{target}{The complete region spanned by the alignments (GRanges)}

\item{keep}{Region to display, relative to the target region, i.e.
not genomic coords (IRanges or GRanges)}

\item{starts}{numeric(n) Insertion locations. When plotting,
the insertion symbol appears at the left border of the
start location.}

\item{gap_nchars}{character(n) Number of letters added to when joining
segments before each region in keep.  If first base of keep is 1,
the first entry of gap_nchars should be 0.}

\item{x}{A vector of group lengths}

\item{offset}{A vector of offset lengths matching x}
}
\value{
Gaps between keep (IRanges), or FALSE if no gap ranges found

insertion_sites (data.frame) with modified start column
}
\description{
(.invertKeepRanges) Internal CrispRVariants function used
by seqsToPartialAlns for checking arguments and getting region to delete.
Returns FALSE if no region to delete found, or region to be deleted is
entire target.

(.checkRelativeLocs) Shift keep to start at 1 if it is
within the target

(.adjustRelativeInsLocs) Internal CrispRVariants function
for shifting insertion locations relative to the target region when
removing a segment of the alignments.  Note that this function does not
do input checking but assumes this has been done upstream. Insertions at
the left border of a gap region are removed.

(.offsetIndices) Get indices of a vector grouped by "x",
cumulatively adding offsets to each group according to "offset"
}
\examples{
CrispRVariants:::.offsetIndices(rep(2,5), c(0:4)*10)
}
\author{
Helen Lindsay
}
