% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mergeCrisprSets}
\alias{mergeCrisprSets}
\alias{mergeCrisprSets,CrisprSet,CrisprSet-method}
\title{Merge two CrisprSets}
\usage{
mergeCrisprSets(x, y, ...)

\S4method{mergeCrisprSets}{CrisprSet,CrisprSet}(
  x,
  y,
  ...,
  x.samples = NULL,
  y.samples = NULL,
  names = NULL,
  order = NULL
)
}
\arguments{
\item{x}{A CrisprSet object}

\item{y}{A second CrisprSet object}

\item{...}{extra arguments}

\item{x.samples}{A subset of column names or indices to keep from CrispRSet x
(Default: NULL, i.e. keep all)}

\item{y.samples}{A subset of column names or indices to keep from CrispRSet y
(Default: NULL, i.e. keep all)}

\item{names}{New names for the merged CrisprSet object (Default: NULL)}

\item{order}{A list of sample names, matching the names in x and y,
specifying the order of the samples in the new CrisprSet. (Not implemented yet)}
}
\value{
A merged CrisprSet object
}
\description{
Merge two CrisprSet objects sharing a reference and target location
}
\examples{
# Load the metadata table
md_fname <- system.file("extdata", "gol_F1_metadata_small.txt", package = "CrispRVariants")
md <- read.table(md_fname, sep = "\t", stringsAsFactors = FALSE)

# Get bam filenames and their full paths
bam_fnames <- sapply(md$bam.filename, function(fn){
 system.file("extdata", fn, package = "CrispRVariants")})

reference <- Biostrings::DNAString("GGTCTCTCGCAGGATGTTGCTGG")
gd <- GenomicRanges::GRanges("18", IRanges::IRanges(4647377, 4647399),
      strand = "+")

crispr_set1 <- readsToTarget(bam_fnames[c(1:4)], target = gd,
      reference = reference, names = md$experiment.name[1:4], target.loc = 17)
crispr_set2 <- readsToTarget(bam_fnames[c(5:8)], target = gd,
      reference = reference, names = md$experiment.name[5:8], target.loc = 17)
mergeCrisprSets(crispr_set1,crispr_set2)
}
\author{
Helen Lindsay
}
