% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{expandMzIntensity}
\alias{expandMzIntensity}
\title{Expand m/z and intensity values in a data.frame}
\usage{
expandMzIntensity(x)
}
\arguments{
\item{x}{\code{data.frame} with \emph{collapsed} m/z and intensity values in columns
\code{"mz"} and \code{"intensity"}, such as returned by \code{\link[=msms_spectra_hmdb]{msms_spectra_hmdb()}} with
parameter \code{collapsed = TRUE}, or by \code{spectra} or \code{compounds} calls.}
}
\value{
\code{data.frame} with \code{"mz"} and \code{"intensity"} columns \emph{expanded}. See
description for details.
}
\description{
\code{expandMzIntensity()} \emph{expands} a \code{data.frame} with m/z and/or intensity
values stored as a \code{list} in columns \code{"mz"} and \code{"intensity"}. The resulting
\code{data.frame} has the m/z and intensity values stored as \code{numeric} in columns
\code{"mz"} and \code{"intensity"}, one value per row, with the content of other
columns repeated as many times as there are m/z and intensity values.
}
\examples{

## Read a data.frame with collapsed columns mz and intensity columns
dr <- system.file("xml/", package = "CompoundDb")
msms_spctra <- msms_spectra_hmdb(dr)

msms_spctra

## Columns mz and intensity are "collased"
msms_spctra$mz

## Expand the data.frame to get one row per m/z and intensity value
spctra_exp <- expandMzIntensity(msms_spctra)
spctra_exp
}
\author{
Johannes Rainer
}
