% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMatrix.R
\name{PlotMatrix}
\alias{PlotMatrix}
\title{Plot Secondary Stain Index matrix}
\usage{
PlotMatrix(output)
}
\arguments{
\item{output}{(matrix): Matrix containing the SSI output.}
}
\value{
(ggplot2) Returns figure containing a matrix of the total compensAID output.
}
\description{
This function plot the SSI matrix, quickly allowing the identification of potential reference errors if a SSI < -1 is obtained.
}
\examples{
# Import FCS file
file <- flowCore::read.FCS(system.file("extdata", "68983.fcs", package = "CompensAID"))

# Run compensAID tool
compensAID.res <- CompensAID(ff = file)

# Plot matrix
figure <- PlotMatrix(output = compensAID.res)
plot(figure)

}
\seealso{
\code{\link{CompensAID}}
}
