% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toFilter.R
\name{toFilter}
\alias{toFilter}
\title{Optional Filtering For Raw Data}
\usage{
toFilter(.data, rank = 1, cl = c("Low", "Middle", "High"))
}
\arguments{
\item{.data}{dataframe}

\item{rank}{integer}

\item{cl}{charater any combination of one or more of 'Low',
'Middle', or 'High'}
}
\value{
a dataframe
}
\description{
Filters only rows with specified values in columns Rank and Confidence Level
, specified as cl
}
\examples{
 
##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
##optional filtering based on rank and confidence level
peptides <- toFilter(peptides, rank = 1)
}
