% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterComp.R
\name{clusterComp}
\alias{clusterComp}
\title{Create components necessary for clustering}
\usage{
clusterComp(.df, scenar = "A", PearsCor = "centered")
}
\arguments{
\item{.df}{data frame, table of normalised protein values}

\item{scenar}{character, scenario intended for clustering, either "A" or "B"}

\item{PearsCor}{character, pearsons correlation variant (centered/uncentered)}
}
\value{
list of data frames
}
\description{
Reformat the table for the one neccessary for assignClusters function.
Calculate the distance matirx using selected variant of correlation.
}
\examples{

##Use example normalised proteins file
inputFile <- system.file("extData", "dataNormProts.txt", package = "ComPrAn")
#read file in and change structure of table to required format
forAnalysis <- protImportForAnalysis(inputFile)
# create components necessary for clustering
clusteringDF <- clusterComp(forAnalysis,scenar = "A", PearsCor = "centered")

}
