% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanData.R
\name{cleanData}
\alias{cleanData}
\title{Clean raw peptide complexomics data}
\usage{
cleanData(.data, fCol = "Search ID")
}
\arguments{
\item{.data}{dataframe}

\item{fCol}{character The column containing the fractions, 
e.g. "Search ID" (default)}
}
\value{
dataframe
}
\description{
Perform initial, mandatory, cleaning of data
Function to process raw input data into format required for
subsequent analysis. .data is a data frame containing raw input data.
This function checks (not neccessarily in this order):
\itemize{
\item renames Sequence ID column to Fraction and converts values in this
 column from letters to numbers
\item reorders Protein Group Accessions containing multiple proteins
\item removes rows in which PSM Ambiguity == 'Rejected'
\item removes rows in which # Protein Groups == 0
\item removes rows in which Precursor Area is NA
\item removes cols that are not used at all
}
}
\examples{
 
##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
}
\author{
Petra Palenikova \email{pp451@cam.ac.uk}

Rick Scavetta \email{office@scavetta.academy}
}
