% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-classes.R, R/initialize-methods.R,
%   R/plot-methods.R, R/projection-methods.R, R/show-methods.R
\docType{class}
\name{Mlp-class}
\alias{Mlp-class}
\alias{.Mlp}
\alias{getData,Mlp-method}
\alias{initialize,Mlp-method}
\alias{plot,Mlp,missing-method}
\alias{mlp}
\alias{mlp,matrix-method}
\alias{Mlp}
\alias{mlp}
\alias{mlp,matrix-method}
\alias{show,Mlp-method}
\title{Projection of points into one dimension.}
\usage{
\S4method{getData}{Mlp}(x, n = NULL)

\S4method{initialize}{Mlp}(.Object, ..., classes, points.orig, line,
  points.onedim, class.color)

\S4method{plot}{Mlp,missing}(x, y, steps = "all", ...)

mlp(mat, ...)

\S4method{mlp}{matrix}(mat, classes, class.color = NULL, ...)

\S4method{show}{Mlp}(object)
}
\arguments{
\item{x}{matrix object for the function mlp otherwise it is a Mlp object}

\item{n}{data to extract from Mlp (NULL gives all)}

\item{.Object}{internal object}

\item{...}{additional arguments to pass on}

\item{classes}{vector in same order as rows in matrix}

\item{points.orig}{multidimensional points describing the original data}

\item{line}{multidimensional points describing a line}

\item{points.onedim}{a vector of points}

\item{class.color}{user assigned group coloring scheme}

\item{y}{default plot param, which should be set to NULL(default: NULL)}

\item{steps}{1,2,3,4,5,6 or "all"}

\item{mat}{matrix with samples on rows, PCs in columns. 
Ordered PCs, with PC1 to the left.}

\item{object}{Mlp object}
}
\value{
The mlp function returns an object of class Mlp
}
\description{
Project points onto the mean based line.
}
\details{
Projection of the points onto a line between the mean of two groups.
Mlp is the abbreviation for 'mean line projection'. The
function accepts, at the moment, only two groups and two PCs at a
time.

An object containing results from a mean line projection reduction to one
dimension.

The group and the one dimensional points are the most important information
to carry out a classification using the classify() function. As a help
to illustrate the details of the dimension reduction, the information from
some critical steps are stored in the object. To visually explore these 
there is a dedicated plot method for Mlp objects, use plot().
}
\examples{

#use demo data
data(mlpMatrix)
groups <- rownames(mlpMatrix)

#run function
prj <- mlp(mlpMatrix, groups)

#getData accessor
getData(prj)

#getData accessor specific
getData(prj, "line")

#plot result
plot(prj)

}
\author{
Jesper R. Gadin and Jason T. Serviss
}
\keyword{projection}
