% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-classes.R, R/classifier-methods.R,
%   R/initialize-methods.R, R/plot-methods.R, R/show-methods.R
\docType{class}
\name{ClassifiedPoints-class}
\alias{ClassifiedPoints-class}
\alias{.ClassifiedPoints}
\alias{getData,ClassifiedPoints-method}
\alias{classify}
\alias{classify,Pcp-method}
\alias{classify,Mlp-method}
\alias{ClassifiedPoints}
\alias{classify}
\alias{classify,Pcp-method}
\alias{classify,Mlp-method}
\alias{initialize,ClassifiedPoints-method}
\alias{plot,ClassifiedPoints,missing-method}
\alias{show,ClassifiedPoints-method}
\title{Classification of the one dimensional points in a Pcp or Mlp object.}
\usage{
\S4method{getData}{ClassifiedPoints}(x, n = NULL)

classify(x, ...)

\S4method{classify}{Pcp}(x, ...)

\S4method{classify}{Mlp}(x, ...)

\S4method{initialize}{ClassifiedPoints}(.Object, ..., scores,
  scores.points = scores.points, scores.index = scores.index, ROC, AUC,
  class.color)

\S4method{plot}{ClassifiedPoints,missing}(x, y, comparison = "all",
  class.color = NULL, ...)

\S4method{show}{ClassifiedPoints}(object)
}
\arguments{
\item{x}{Pcp or Mlp Object for the function classify otherwise it is a 
ClassifiedPoints object}

\item{n}{data to extract from ClassifiedPoints (NULL gives all)}

\item{...}{additional arguments to pass on}

\item{.Object}{internal object}

\item{scores}{final scores}

\item{scores.points}{sorted points}

\item{scores.index}{index of sorted points}

\item{ROC}{parameters (TN, TP, FN and FP)}

\item{AUC}{area under the curve}

\item{class.color}{user assigned group coloring scheme}

\item{y}{default plot param, which should be set to NULL}

\item{comparison}{Specify a comparison i.e.
("grp1 vs grp2") and plot only that comparison.}

\item{object}{ClassifiedPoints Object}
}
\value{
The classify function returns an object of class ClassifiedPoints
}
\description{
Classification based on ROC params (TN TP FP FN).
}
\details{
Tests all possible discrimination lines and picks the one with highest score
based on a score which is simply calculated by the formula
(TP - FP) + (TN - FN).

The plot shows the distribution of scores for different discrimination lines.
Each line is a separator that has a score for the separation of the two 
groups, and the height of the line marks the score for this separation.
}
\examples{

#use demo data
data(pcpMatrix)
classes <- rownames(pcpMatrix)

#run function
prj <- pcp(pcpMatrix, classes)
cl <- classify(prj)

#getData accessor
getData(cl)

#getData accessor specific
getData(cl, "scores")

#plot result
plot(cl)

}
\author{
Jesper R. Gadin and Jason T. Serviss
}
\keyword{classification}
