% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{extractResults}
\alias{extractResults}
\alias{extractResults,ClustAllObject-method}
\title{Extract Clustering Results from ClustAllObject}
\usage{
extractResults(Object)
}
\arguments{
\item{Object}{A processed \code{\link{ClustAllObject-class}} object. The object
must have been processed by \code{\link{runClustAll}} before using this function.}
}
\value{
A list containing two elements:
\itemize{
  \item All_clusters: A list of all stratifications generated by the ClustALL algorithm.
  \item Robust_clusters: A list of statistically robust stratifications that passed
    the bootstrapping process.
}
If \code{\link{runClustAll}} has not been executed, the function returns a list
with a single NULL element.
}
\description{
This function retrieves the complete set of clustering results from a
processed ClustAllObject, including all generated stratifications and the
subset of statistically robust stratifications. It provides comprehensive
access to the outcomes of the ClustALL algorithm.
}
\details{
The extractResults function provides comprehensive access to the clustering
outcomes of the ClustALL algorithm:
\itemize{
  \item All_clusters: Contains every stratification generated, regardless of
    statistical robustness. Each element is a vector of cluster assignments
    for the samples.
  \item Robust_clusters: A subset of All_clusters, containing only those
    stratifications that passed the bootstrapping process for population-based
    robustness.
}
This function is particularly useful for:
\itemize{
  \item Comprehensive analysis of all generated clustering solutions.
  \item Comparing robust stratifications with non-robust ones.
  \item Exporting clustering results for further analysis in other tools.
  \item Assessing the impact of robustness criteria on stratification selection.
}
}
\note{
This function will return a list with a single NULL element if
\code{\link{runClustAll}} has not been executed on the object. Always check
if the returned list contains valid results before proceeding with analysis.
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=-ID)
\donttest{
obj_noNA <- createClustAll(data = wdbc, colValidation = "Diagnosis")
obj_noNA1 <- runClustAll(Object = obj_noNA, threads = 1, simplify = TRUE)
extractResults(obj_noNA1)
}

}
\seealso{
\code{\link{runClustAll}}, \code{\link{summary_clusters}},
\code{\link{resStratification}}, \code{\link{ClustAllObject-class}}
}
