% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{addValidationData}
\alias{addValidationData}
\alias{addValidationData,ClustAllObject,numericOrCharacter-method}
\title{Add Validation Data to ClustAllObject}
\usage{
addValidationData(Object, dataValidation)
}
\arguments{
\item{Object}{A \code{\link{ClustAllObject-class}} object created by
\code{\link{createClustAll}}.}

\item{dataValidation}{A numeric or character vector containing the validation
data (true labels) for the samples. The length of this vector must match the
number of rows in the original input data used in
\code{\link{createClustAll}}.}
}
\value{
An updated \code{\link{ClustAllObject-class}} object with the new
validation data added to the dataValidation slot.
}
\description{
This function adds or updates the validation data (true labels) in a
ClustAllObject. It allows users to incorporate known classifications or
groupings of samples after the object has been created, enabling subsequent
evaluation of clustering results against these true labels.
}
\details{
Adding validation data to a ClustAllObject is crucial for assessing the
performance of clustering results. This function allows for flexible
workflow where true labels can be incorporated at any stage of the analysis:
\itemize{
  \item It can be used to add validation data that was not available during
    initial object creation.
  \item It can also update existing validation data with new or corrected labels.
  \item The added data can be used with functions like
  \code{\link{validateStratification}}
    to evaluate clustering performance.
}
Key points to consider:
\itemize{
  \item The length of dataValidation must exactly match the number of samples
    in the original dataset.
  \item If the object already contains validation data, this function will
    overwrite it with the new data.
  \item Both numeric and character vectors are accepted, allowing for various
    types of classification schemes.
}
}
\note{
This function modifies the 'dataValidation' slot of the ClustAllObject in-place.
Always ensure that the provided validation data correctly corresponds to the
samples in your dataset to avoid misinterpretation of subsequent analyses.
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
label <- as.numeric(as.factor(wdbc$Diagnosis))
wdbc <- wdbc[,-c(1, 2)] # delete patients IDs & label
obj_noNA <- createClustAll(data = wdbc)
obj_noNA <- addValidationData(Object = obj_noNA,
                              dataValidation = label)
}
\seealso{
\code{\link{createClustAll}}, \code{\link{dataValidation}},
\code{\link{validateStratification}}, \code{\link{ClustAllObject-class}}
}
