% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes_methods.R
\docType{methods}
\name{cossim}
\alias{cossim}
\alias{cossim,MS2spectrum,MS2spectrum-method}
\alias{cossim,pseudospectrum,pseudospectrum-method}
\title{Calculate cosine similarity between two spectra}
\usage{
cossim(x, y, type = c("spectrum", "neutral_losses"),
    mzTolerance = 1e-05)

\S4method{cossim}{MS2spectrum,MS2spectrum}(x, y, type = c("spectrum",
    "neutral_losses"), mzTolerance = 1e-05)

\S4method{cossim}{pseudospectrum,pseudospectrum}(x, y,
    type = c("spectrum", "neutral_losses"), mzTolerance = 1e-05)
}
\arguments{
\item{x, y}{MS2 spectra, either as \code{matrix},
\code{\linkS4class{MS2spectrum}} or \code{\linkS4class{pseudospectrum}}
objects. \code{x} and \code{y} must have the same class.}

\item{type}{Whether similarity between spectra (\code{"spectrum"}, default)
or neutral loss patterns (\code{"neutral_losses"}) is to be compared}

\item{mzTolerance}{The m/z tolerance used for merging. If two fragment peaks
are within tolerance, they are regarded as the same. Defaults to
\code{1e-5}, i.e. 10ppm.}
}
\value{
The cosine similarity of \code{x} and \code{y}
}
\description{
\code{cossim()} calculates the cosine of the spectral constrast angle as a
measure for the similarity of two spectra.
}
\section{Methods (by class)}{
\itemize{
\item \code{x = MS2spectrum,y = MS2spectrum}: \code{cossim} method for
\code{\linkS4class{MS2spectrum}} objects

\item \code{x = pseudospectrum,y = pseudospectrum}: \code{cossim} method for
\code{\linkS4class{pseudospectrum}} objects
}}

\examples{
load(file = system.file("extdata",
    "annotatedSpeclist.RData",
    package = "CluMSIDdata"))

cossim(annotatedSpeclist[[1]], annotatedSpeclist[[2]])

}
